#include <avr/wdt.h>          // Bibliothek einbinden, die einen Sensorbug beheben kann.

int trigPin = 3;              // Der Variablen des Typs int ( = Integer d.h. ganze Zahlen) namens "trigPin" wird der Wert 3 zugeordnet. Mit diesem Pin ist der Ultraschallsensor verbinden
int echoPin = 2;              // Der Variablen des Typs int ( = Integer d.h. ganze Zahlen) namens "echoPin" wird der Wert 2 zugeordnet. Mit diesem Pin ist der Ultraschallsensor verbinden
                              // Im Laufe des Programms können somit die beiden digitalen Pins 3 und 2 mit dem jeweiligen Variablennamen >> trigPin << und >> echoPin << (statt der Ziffer des Anschlusses) aufgerufen werden. Dadurch wird es einfacher.
                    
float t;                      // Es wird eine Variable des Typs float ( d.h. Fließkommazahl, also "gebrochene Zahlen") namens t angelegt. Hier wird später die Laufzeit gespeichert.
float s;                      // Es wird eine Variable des Typs float ( d.h. Fließkommazahl, also "gebrochene Zahlen") namens s angelegt. Hier wird später die Strecke gespeichert.



void setup() {                  // Das Setup wird 1x ausgeführt
  
  Serial.begin(9600);           // Hier wird der serielle Monitor initialisiert (die Geschwindigkeit wird auf 9600 Signaländerungen/Sekunde gesetzt. In der Arduino-IDE muss der gleiche Wert eingestellt sein).

  pinMode(trigPin, OUTPUT);     // Der oben definierte "trigPin" (also digitaler Pin 3) wird als OUTPUT (d.h. Ausgang) festgelegt.
  pinMode(echoPin, INPUT);      // Der "echoPin" (also digitaler Pin 2) wird als INPUT (d.h. Eingang) festgelegt.

  pinMode (4, OUTPUT);          // Auch die Funktion der übrigen I/O-Pins (Ein- und Ausgangs-Pins) müssen definiert werden. An Pin 4 befindet sich der Piezosummer
  pinMode (6, OUTPUT);          // Pin 6 = grüne LED
  pinMode (9, OUTPUT);          // Pin 9 = gelbe LED
  pinMode (11, OUTPUT);         // Pin 11 = rote LED

  }                             // Ende Setup



void loop() {                   // Die loop (Schleife) wird immer wieder ausgeführt.

  
  delayMicroseconds(3);         // 3 Microsekunden warten.
  digitalWrite(trigPin, HIGH);  // Trigger-Pin auf HIGH, er sendet ab jetzt ein 40kHz-Ultraschallsignal.
  delayMicroseconds(5);         // 5 Microsekunden warten, der Trigger-Pin bleibt solange HIGH.
  digitalWrite(trigPin, LOW);   // Trigger-Pin auf LOW. Das Signal wurde also 5 Microsekunden lang gesendet.

                                // Das Ultraschall-Signal wurde nun vom Ultraschallsensor gesendet. Nun "warten" wir auf das Echo.

  t = pulseIn(echoPin, HIGH);   // Der Variablen "t" wird ein Wert in Microsekunden zugewiesen, der mit der Funktion pulseIn() bestimmt wird.
                                // pulseIn() misst die Zeit, bis der Echo-Pin wieder auf HIGH steht. Der Sensor setzt den EchoPin auf HIGH, wenn er das von einem Objekt reflektierte Ultraschallsignal erhält.
                                // Damit ist die Laufzeitmessung fertig. Der Wert für die Laufzeit des Signals in Millisekunden ist in der Variablen t.

  SensorBugBeheben();           // Zur Sicherheit wird nun die Funktion SensorBugBeheben(); ausgeführt. Diese ist ganz am Ende im Programmcode definiert, soll aber hier nicht weiter erklärt werden.


// s = 340 * (t/2000000);       // Diese Codezeile ist zunächst noch auskommentiert und wird daher vom Arduino ignoriert. Hier wird die Strecke s mit s = v * t berechnet. da t in Mikrosekunden vorliegt, muss mit /1000000 von Mikrosekunden in Sekunden umgerechnet werden. v ist mit 340 m/s angegeben.

   
  Serial.print ("t");           // "t" wird auf den seriellen Monitor geschrieben.
  Serial.println (t);           // Der Wert der Variablen "t" wird auf den seriellen Monitor geschrieben. Serial.println lässt im Unterschied zu Serial.print außerdem eine neue Zeile beginnen
 
  
  if (t < 1000) {               // Dies ist eine Abfrage. Wenn ... dann ... sonst ... Es wird geprüft, ob die Variable t kleiner als 1000 ist.
    digitalWrite (6, HIGH);}    // Wenn t < 1000, dann wird Pin 6 auf HIGH gesetzt, also die angeschlossene LED angeschaltet.
  else {                        // ansonsten wird...
    digitalWrite (6, LOW);}     // Pin 6 auf LOW gesetzt, also die angeschlossene LED ausgeschaltet.



   delay (200);                 // 200 ms warten


  }                             // Ende der loop ( = Schleife)



void SensorBugBeheben(){      // Diese Funktion behebt einen Bug des Sensors. Falls er kein Signal zurückerhält, hängt er sich manchmal auf und gibt den Wert 0 zurück.
  
  if (t == 0){
    wdt_enable(WDTO_15MS);    // Reset des Arduinos
  } 
 
} 

/*  P4_Utraschallsensor_14.05.2019
 
    **********************************************************
    AUFGABEN (Hinweise und Lösungen finden Sie am Ende!)
    **********************************************************
    
    1   VORBEREITUNG - Laden Sie dieses Programm unverändert auf den Aruino hoch. Wenn alles geklappt hat, ertönt der Summer kurz. 

    1   SERIELLER MONITOR - Das Basisprogramm schreibt die Laufzeit des Ultraschallsignals auf dem seriellen Monitor aus. 
        Öffnen Sie den seriellen Monitor in der Arduino-IDE (--> Lupe oben rechts). Variieren Sie den Abstand zwischen dem Ultraschallsensor und Ihrer Hand. Der Ultraschallsensor kann einen Bereich von 2cm bis ca. 4m erfassen.


    2   SERIELLEN MONITOR BESCHRIFTEN - Optimieren Sie die Ausgabe auf dem seriellen Monitor (bspw. „Laufzeit t: <WERT> ms“). Modifizieren Sie dazu die bestehenden Programmzeilen. 
        Fügen Sie eine Pause zwischen den einzelnen Ausgaben von einer halben Sekunde ein. 


    4   ZUSÄTZLICHE ANGABEN AUF SERIELLEM MONITOR - Lassen Sie den Arduino die Laufzeit in einen Abstand umrechnen. 
        Lassen Sie den Abstand s zusätzlich zur Laufzeit auf dem seriellen Monitor ausgeben.

  
    5   UMRECHNUNG ANPASSEN - Testen Sie, ob die Anzeige des Abstandes mit dem tatsächlichen Abstand übereinstimmt. 
        Überprüfen Sie die Formel zur Berechnung und passen Sie den Programmcode an. 


    6   MESSBEREICH ERMITTELN - Ermitteln Sie den minimalen und maximalen Messbereich des Sensors.  


    7   EINFLUSS DES WINKELS - Testen Sie den Einfluss des Winkels des Hindernisses auf die Messung. Funktioniert die Messung bei jedem Winkel? 


    8   EINFLUSS DES MATERIALS - Testen Sie den Einfluss verschiedener Materialien auf den Sensor. Zeigt der Sensor bspw. bei sehr weichen Materialien andere Werte an? 


    9   EINFLUSS EINER KERZE - Was passiert, wenn Sie eine Kerze in die Messsstrecke zwischen Sensor und Hindernis stellen? Wie lassen sich die Ergebnisse erklären?


    10  OPTISCHE EINPARKHILFE - Programmieren Sie eine optische Einparkhilfe. Steuern Sie die LEDs in Abhängigkeit vom Abstand an.


    10  AKUSTISCHE EINPARKHILFE - Programmieren Sie eine akutische Einparkhilfe. Steuern Sie den Summer in Abhängigkeit vom Abstand an.


    11  EINPARKMELODIE (EXPERTENAUFGABE) - Einparken könnte so viel mehr Spaß machen, wenn dabei Musik gespielt würde. Komponieren Sie eine "Einparkmelodie". 


*****************************************************************************************

LÖSUNGSHINWEISE

2   Lösung: Passen Sie den bestehdenen Befehl an. z.B: >>  Serial.print ("Laufzeit: "); <<    

3   Lösung: Eine Pause von 1000ms (also 1 Sekunde) wird mit delay(1000); ausgeführt.

4   Lösung: Entfernen Sie die >> // << vor der Zeile mit >> //  s = 340 * (t/1000000); ... <<

5   Überlegen Sie, welchen Weg das Signal zurücklegt. Dieser Weg muss in der Formel noch durch einen Faktor berücksichtigt werden.

    Lösung: Das Signal legt die doppelte Strecke des Abstandes zurück. Ändern Sie daher die Formel z.B. in >> s = 340 * (t/2000000); <<

9   Eine einfache Schleife ist am Ende des Programmes schon enthalten. Fragen Sie anstatt der Laufzeit den Abstand ab. 
    Kopieren Sie die Schleife und ändern Sie Abstände und angesteuerte LED. 
    Der Befehl für den Summer steht ganz am Anfang des Programms und kann in die Schleife eingebaut werden.


*****************************************************************************************/
